#include <iostream>
#include <inttypes.h>
#include <stdlib.h>

using namespace std;

typedef struct queue_node_t {
    queue_node_t* next;
    uint32_t value;
} queue_node_t;

typedef struct {
    queue_node_t* headNode;
    queue_node_t* lastNode;
    uint32_t elementsCount;
} queue_t;

void queue_push(queue_t* q, uint32_t val) {
    queue_node_t* newNode=(queue_node_t *) malloc(sizeof(queue_node_t));
    newNode->value=val;
    if(q->elementsCount>0) {
        q->lastNode->next=newNode;
    }
    else {
        q->headNode=newNode;
    }
    q->lastNode=newNode;
    q->elementsCount++;
    return;
}

uint32_t queue_front(queue_t* q) {
    return q->headNode->value;
}

void queue_pop(queue_t* q) {
    queue_node_t* temp=q->headNode;
    q->headNode=q->headNode->next;
    free(temp);
    q->elementsCount--;
}


int main()
{
    uint32_t n, q;
    scanf("%"SCNu32 " %"SCNu32, &n, &q);
    uint32_t A[n];
    for(uint32_t i=0;i<n;i++) {
        scanf("%"SCNu32, &A[i]);
    }

    // Podnizovi
    for(uint32_t i=0;i<q;i++) {
        uint32_t L, R;
        queue_t q;
        q.elementsCount=0;
        q.headNode=NULL; q.lastNode=NULL;
        scanf("%"SCNu32 " %"SCNu32, &L, &R);
        // Dodamo u queue one koji nisu u dobrom nizu (za pocetak dodajemo 0. index)
        queue_push(&q, L-1);
        uint32_t longestGoodSubset=0;
        while(q.elementsCount!=0) {
            uint32_t currentIndex=queue_front(&q);
            uint32_t lastElement=A[currentIndex];
            uint32_t currentGoodSubset=0;
            queue_pop(&q);
            for(uint32_t curr=currentIndex;curr<R;curr++) {
                            //printf("current = A[%u] = %u\nLast element = %u\n", curr, A[curr], lastElement);
                if((A[curr]&lastElement)>(A[curr]^lastElement)) {
                    lastElement=A[curr];
                    currentGoodSubset++;
                            //printf("Changed last element to %u\n", lastElement);
                }
                else {
                            //printf("Pushed back %u\n", curr);
                    queue_push(&q, curr);
                }
            }
            if(currentGoodSubset>longestGoodSubset) {
                longestGoodSubset=currentGoodSubset;
            }
        }
        cout << longestGoodSubset << endl;
    }
    return 0;
}